#ifndef DM_OS_LINUX_H
#define DM_OS_LINUX_H

#include "../../CrestCore/inc/interface/dm_os.h"

/* TODO: For future super event-waiting function. */
enum EventOp {
    DM_OS_EVENT_CONSUME    = 0x00,
    DM_OS_EVENT_NO_CONSUME = 0x01,
    DM_OS_EVENT_ANY        = 0x00,
    DM_OS_EVENT_ALL        = 0x02,
};

/**
 * The Dm interfaces were found lacking, these separate interfaces are necessary
 * for the API as currently written.
 */
void HwDelayUsec(UINT32 us);

INT32 OsQueueBytes(UINT32 handle, const void* item, UINT32 itemSize);
INT32 OsDequeueBytes(UINT32 handle, void* item, UINT32 itemSize);
void OsQueueReset(UINT32 handle);
UINT32 OsQueueSize(UINT32 handle);

/* These should probably be combined into some super event-waiting function. */
UINT32 OsWaitEventGroupTimeout(UINT32 eventHandle, UINT32 mask, UINT32 waitTime);
UINT32 OsWaitEventGroupAll(UINT32 eventHandle, UINT32 mask);
void OsClearEvent(UINT32 eventHandle, UINT32 mask);
INT32 OsDequeueBytesWait(UINT32 handle, void* item, UINT32 itemSize, UINT32 timeout);

#endif /* DM_OS_LINUX_H */
